<?php
/**
 * Services Admin Class
 * کلاس ادمین خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Admin {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
        add_action('admin_notices', array($this, 'admin_notices'));
    }
    
    public function add_admin_menu() {
        add_submenu_page(
            'edit.php?post_type=services',
            __('تنظیمات خدمات', 'services-post-type'),
            __('تنظیمات', 'services-post-type'),
            'manage_options',
            'services-settings',
            array($this, 'settings_page')
        );
    }
    
    public function enqueue_admin_scripts($hook) {
        if (strpos($hook, 'services') !== false) {
            wp_enqueue_style('services-admin', SERVICES_PLUGIN_URL . 'admin/css/admin.css', array(), SERVICES_PLUGIN_VERSION);
            wp_enqueue_script('services-admin', SERVICES_PLUGIN_URL . 'admin/js/admin.js', array('jquery'), SERVICES_PLUGIN_VERSION, true);
        }
    }
    
    public function settings_page() {
        ?>
        <div class="wrap">
            <h1><?php _e('تنظیمات خدمات', 'services-post-type'); ?></h1>
            
            <div class="card">
                <h2><?php _e('آمار کلی', 'services-post-type'); ?></h2>
                <table class="form-table">
                    <tr>
                        <th><?php _e('تعداد کل خدمات:', 'services-post-type'); ?></th>
                        <td><strong><?php echo wp_count_posts('services')->publish; ?></strong></td>
                    </tr>
                    <tr>
                        <th><?php _e('تعداد دسته‌بندی‌ها:', 'services-post-type'); ?></th>
                        <td><strong><?php echo wp_count_terms('service-category'); ?></strong></td>
                    </tr>
                </table>
            </div>
            
            <div class="card">
                <h2><?php _e('شورت‌کدهای موجود', 'services-post-type'); ?></h2>
                <p><?php _e('برای نمایش خدمات مشتری:', 'services-post-type'); ?></p>
                <code>[customer_services]</code>
                <br><br>
                <p><?php _e('برای نمایش تعداد خدمات:', 'services-post-type'); ?></p>
                <code>[customer_services_count]</code>
            </div>
        </div>
        <?php
    }
    
    public function admin_notices() {
        // بررسی وجود نوع پست customers
        if (!post_type_exists('customers')) {
            ?>
            <div class="notice notice-warning">
                <p><?php _e('توجه: نوع پست "customers" یافت نشد. برای عملکرد کامل پلاگین، ابتدا نوع پست مشتریان را ایجاد کنید.', 'services-post-type'); ?></p>
            </div>
            <?php
        }
    }
}