<?php
/**
 * Services Admin Columns Class
 * کلاس ستون‌های ادمین خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Admin_Columns {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        // ستون‌های مشتریان
        add_filter('manage_customers_posts_columns', array($this, 'add_customer_services_column'));
        add_action('manage_customers_posts_custom_column', array($this, 'show_customer_services_column'), 10, 2);
        
        // ستون‌های خدمات
        add_filter('manage_services_posts_columns', array($this, 'add_services_columns'));
        add_action('manage_services_posts_custom_column', array($this, 'show_services_columns'), 10, 2);
        
        // فیلترهای ادمین
        add_action('restrict_manage_posts', array($this, 'add_services_customer_filter'));
        add_filter('parse_query', array($this, 'filter_services_by_customer'));
    }
    
    public function add_customer_services_column($columns) {
        $columns['services_count'] = __('تعداد خدمات', 'services-post-type');
        return $columns;
    }
    
    public function show_customer_services_column($column, $post_id) {
        if ($column === 'services_count') {
            $count = get_customer_services_count($post_id);
            echo '<strong>' . $count . '</strong>';
            if ($count > 0) {
                echo '<br><small><a href="' . admin_url('edit.php?post_type=services&customer_filter=' . $post_id) . '">' . __('مشاهده خدمات', 'services-post-type') . '</a></small>';
            }
        }
    }
    
    public function add_services_columns($columns) {
        $columns['customer_name'] = __('مشتری مرتبط', 'services-post-type');
        $columns['service_status'] = __('وضعیت', 'services-post-type');
        $columns['service_price'] = __('قیمت', 'services-post-type');
        return $columns;
    }
    
    public function show_services_columns($column, $post_id) {
        if ($column === 'customer_name') {
            $customer_id = get_post_meta($post_id, 'customer_relation', true);
            if ($customer_id) {
                $customer = get_post($customer_id);
                if ($customer) {
                    echo '<strong><a href="' . get_edit_post_link($customer_id) . '">' . esc_html($customer->post_title) . '</a></strong>';
                }
            } else {
                echo '<span style="color: #999;">' . __('مشتری انتخاب نشده', 'services-post-type') . '</span>';
            }
        }
        
        if ($column === 'service_status') {
            $status = get_post_meta($post_id, 'service_status', true);
            $status_labels = array(
                'planning' => '<span style="color: #f56500;">' . __('در حال برنامه‌ریزی', 'services-post-type') . '</span>',
                'in_progress' => '<span style="color: #0073aa;">' . __('در حال انجام', 'services-post-type') . '</span>',
                'completed' => '<span style="color: #46b450;">' . __('تکمیل شده', 'services-post-type') . '</span>',
                'on_hold' => '<span style="color: #ffb900;">' . __('متوقف شده', 'services-post-type') . '</span>',
                'cancelled' => '<span style="color: #dc3232;">' . __('لغو شده', 'services-post-type') . '</span>'
            );
            
            echo isset($status_labels[$status]) ? $status_labels[$status] : '<span style="color: #999;">' . __('تعریف نشده', 'services-post-type') . '</span>';
        }
        
        if ($column === 'service_price') {
            $price = get_post_meta($post_id, 'service_price', true);
            if ($price) {
                echo '<strong>' . number_format($price) . ' ' . __('تومان', 'services-post-type') . '</strong>';
            } else {
                echo '<span style="color: #999;">' . __('تعریف نشده', 'services-post-type') . '</span>';
            }
        }
    }
    
    public function add_services_customer_filter() {
        global $typenow;
        
        if ($typenow == 'services') {
            $customers = get_posts(array(
                'post_type' => 'customers',
                'posts_per_page' => -1,
                'post_status' => 'publish',
                'orderby' => 'title',
                'order' => 'ASC'
            ));
            
            $selected_customer = isset($_GET['customer_filter']) ? $_GET['customer_filter'] : '';
            
            echo '<select name="customer_filter">';
            echo '<option value="">' . __('همه مشتریان', 'services-post-type') . '</option>';
            
            foreach ($customers as $customer) {
                $selected = selected($selected_customer, $customer->ID, false);
                echo '<option value="' . $customer->ID . '" ' . $selected . '>' . esc_html($customer->post_title) . '</option>';
            }
            
            echo '</select>';
        }
    }
    
    public function filter_services_by_customer($query) {
        global $pagenow;
        
        if (is_admin() && $pagenow == 'edit.php' && 
            isset($_GET['post_type']) && $_GET['post_type'] == 'services' && 
            isset($_GET['customer_filter']) && $_GET['customer_filter'] != '') {
            
            $query->query_vars['meta_key'] = 'customer_relation';
            $query->query_vars['meta_value'] = $_GET['customer_filter'];
        }
    }
}