<?php
/**
 * Services Image Settings Class
 * کلاس تنظیمات تصاویر خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Image_Settings {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('after_setup_theme', array($this, 'add_custom_image_sizes'));
        add_filter('jpeg_quality', array($this, 'improve_jpeg_quality'), 10, 2);
        add_filter('wp_editor_set_quality', array($this, 'improve_jpeg_quality'), 10, 2);
        add_action('init', array($this, 'disable_image_compression'));
    }
    
    public function add_custom_image_sizes() {
        add_image_size('service-high-quality', 1200, 1800, false); // برای طراحی وب
        add_image_size('service-standard', 600, 450, true); // برای سایر خدمات
    }
    
    public function improve_jpeg_quality($quality, $context) {
        return 100; // حداکثر کیفیت
    }
    
    public function disable_image_compression() {
        add_filter('big_image_size_threshold', '__return_false');
    }
}