<?php
/**
 * Services Meta Boxes Class
 * کلاس متا باکس‌های خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Meta_Boxes {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('add_meta_boxes', array($this, 'add_meta_boxes'));
        add_action('save_post', array($this, 'save_meta_data'));
    }
    
    public function add_meta_boxes() {
        add_meta_box(
            'service_customer_relation',
            __('تنظیمات خدمت', 'services-post-type'),
            array($this, 'customer_relation_callback'),
            'services',
            'side',
            'high'
        );
        
        add_meta_box(
            'service_details',
            __('جزئیات خدمت', 'services-post-type'),
            array($this, 'service_details_callback'),
            'services',
            'normal',
            'default'
        );
    }
    
    public function customer_relation_callback($post) {
        wp_nonce_field('save_service_customer_relation', 'service_customer_relation_nonce');
        
        $selected_customer = get_post_meta($post->ID, 'customer_relation', true);
        
        // دریافت لیست مشتریان
        $customers = get_posts(array(
            'post_type' => 'customers',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC'
        ));
        
        echo '<table class="form-table">';
        echo '<tr>';
        echo '<th><label for="customer_relation">' . __('مشتری مرتبط:', 'services-post-type') . '</label></th>';
        echo '<td>';
        echo '<select name="customer_relation" id="customer_relation" class="widefat" required>';
        echo '<option value="">' . __('انتخاب مشتری...', 'services-post-type') . '</option>';
        
        foreach ($customers as $customer) {
            $selected = selected($selected_customer, $customer->ID, false);
            echo '<option value="' . $customer->ID . '" ' . $selected . '>' . esc_html($customer->post_title) . '</option>';
        }
        
        echo '</select>';
        echo '<p class="description">' . __('مشتری مرتبط با این خدمت را انتخاب کنید.', 'services-post-type') . '</p>';
        echo '</td>';
        echo '</tr>';
        echo '</table>';
    }
    
    public function service_details_callback($post) {
        wp_nonce_field('save_service_details', 'service_details_nonce');
        
        $start_date = get_post_meta($post->ID, 'service_start_date', true);
        $end_date = get_post_meta($post->ID, 'service_end_date', true);
        $status = get_post_meta($post->ID, 'service_status', true);
        $price = get_post_meta($post->ID, 'service_price', true);
        
        ?>
        <table class="form-table">
            <tr>
                <th><label for="service_start_date"><?php _e('تاریخ شروع:', 'services-post-type'); ?></label></th>
                <td><input type="date" name="service_start_date" id="service_start_date" value="<?php echo esc_attr($start_date); ?>" class="regular-text" /></td>
            </tr>
            <tr>
                <th><label for="service_end_date"><?php _e('تاریخ پایان:', 'services-post-type'); ?></label></th>
                <td><input type="date" name="service_end_date" id="service_end_date" value="<?php echo esc_attr($end_date); ?>" class="regular-text" /></td>
            </tr>
            <tr>
                <th><label for="service_status"><?php _e('وضعیت خدمت:', 'services-post-type'); ?></label></th>
                <td>
                    <select name="service_status" id="service_status" class="regular-text">
                        <option value="planning" <?php selected($status, 'planning'); ?>><?php _e('در حال برنامه‌ریزی', 'services-post-type'); ?></option>
                        <option value="in_progress" <?php selected($status, 'in_progress'); ?>><?php _e('در حال انجام', 'services-post-type'); ?></option>
                        <option value="completed" <?php selected($status, 'completed'); ?>><?php _e('تکمیل شده', 'services-post-type'); ?></option>
                        <option value="on_hold" <?php selected($status, 'on_hold'); ?>><?php _e('متوقف شده', 'services-post-type'); ?></option>
                        <option value="cancelled" <?php selected($status, 'cancelled'); ?>><?php _e('لغو شده', 'services-post-type'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label for="service_price"><?php _e('قیمت خدمت (تومان):', 'services-post-type'); ?></label></th>
                <td><input type="number" name="service_price" id="service_price" value="<?php echo esc_attr($price); ?>" class="regular-text" min="0" step="1000" /></td>
            </tr>
        </table>
        <?php
    }
    
    public function save_meta_data($post_id) {
        // بررسی نوع پست
        if (get_post_type($post_id) !== 'services') {
            return;
        }
        
        // بررسی اختیارات کاربر
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        
        // بررسی nonce برای customer relation
        if (isset($_POST['service_customer_relation_nonce']) && 
            wp_verify_nonce($_POST['service_customer_relation_nonce'], 'save_service_customer_relation')) {
            
            if (isset($_POST['customer_relation'])) {
                update_post_meta($post_id, 'customer_relation', sanitize_text_field($_POST['customer_relation']));
            }
        }
        
        // بررسی nonce برای service details
        if (isset($_POST['service_details_nonce']) && 
            wp_verify_nonce($_POST['service_details_nonce'], 'save_service_details')) {
            
            $fields = array('service_start_date', 'service_end_date', 'service_status', 'service_price');
            
            foreach ($fields as $field) {
                if (isset($_POST[$field])) {
                    update_post_meta($post_id, $field, sanitize_text_field($_POST[$field]));
                }
            }
        }
    }
}