<?php
/**
 * Services Post Type Class
 * کلاس نوع پست خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Post_Type {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'register_post_type'));
        add_action('template_redirect', array($this, 'disable_single_pages'));
        add_filter('wp_sitemaps_post_types', array($this, 'exclude_from_sitemap'), 10, 2);
    }
    
    public function register_post_type() {
        $labels = array(
            'name'                  => __('خدمات ارائه شده', 'services-post-type'),
            'singular_name'         => __('خدمت ارائه شده', 'services-post-type'),
            'menu_name'            => __('خدمات ارائه شده', 'services-post-type'),
            'name_admin_bar'       => __('خدمت ارائه شده', 'services-post-type'),
            'archives'             => __('آرشیو خدمات', 'services-post-type'),
            'attributes'           => __('ویژگی‌های خدمت', 'services-post-type'),
            'parent_item_colon'    => __('خدمت والد:', 'services-post-type'),
            'all_items'            => __('همه خدمات', 'services-post-type'),
            'add_new_item'         => __('افزودن خدمت جدید', 'services-post-type'),
            'add_new'              => __('افزودن جدید', 'services-post-type'),
            'new_item'             => __('خدمت جدید', 'services-post-type'),
            'edit_item'            => __('ویرایش خدمت', 'services-post-type'),
            'update_item'          => __('بروزرسانی خدمت', 'services-post-type'),
            'view_item'            => __('مشاهده خدمت', 'services-post-type'),
            'view_items'           => __('مشاهده خدمات', 'services-post-type'),
            'search_items'         => __('جستجو خدمات', 'services-post-type'),
            'not_found'            => __('خدمتی یافت نشد', 'services-post-type'),
            'not_found_in_trash'   => __('خدمتی در زباله‌دان یافت نشد', 'services-post-type'),
            'featured_image'       => __('تصویر خدمت', 'services-post-type'),
            'set_featured_image'   => __('انتخاب تصویر خدمت', 'services-post-type'),
            'remove_featured_image' => __('حذف تصویر خدمت', 'services-post-type'),
            'use_featured_image'   => __('استفاده به عنوان تصویر خدمت', 'services-post-type'),
            'insert_into_item'     => __('درج در خدمت', 'services-post-type'),
            'uploaded_to_this_item' => __('آپلود شده برای این خدمت', 'services-post-type'),
            'items_list'           => __('لیست خدمات', 'services-post-type'),
            'items_list_navigation' => __('ناوبری لیست خدمات', 'services-post-type'),
            'filter_items_list'    => __('فیلتر لیست خدمات', 'services-post-type'),
        );

        $args = array(
            'label'                => __('خدمت ارائه شده', 'services-post-type'),
            'description'          => __('خدمات ارائه شده به مشتریان', 'services-post-type'),
            'labels'               => $labels,
            'supports'             => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
            'taxonomies'           => array('service-category'),
            'hierarchical'         => false,
            'public'               => true,
            'show_ui'              => true,
            'show_in_menu'         => true,
            'menu_position'        => 5,
            'menu_icon'            => 'dashicons-admin-tools',
            'show_in_admin_bar'    => true,
            'show_in_nav_menus'    => true,
            'can_export'           => true,
            'has_archive'          => false,
            'exclude_from_search'  => true,
            'publicly_queryable'   => false,
            'show_in_rest'         => true,
            'capability_type'      => 'post',
        );

        register_post_type('services', $args);
    }
    
    public function disable_single_pages() {
        if (is_singular('services')) {
            wp_redirect(home_url(), 301);
            exit;
        }
    }
    
    public function exclude_from_sitemap($args, $post_type) {
        if ($post_type === 'services') {
            return false;
        }
        return $args;
    }
}