<?php
/**
 * Services Taxonomy Class
 * کلاس تکسونومی خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

class Services_Taxonomy {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'register_taxonomy'));
    }
    
    public function register_taxonomy() {
        $labels = array(
            'name'                       => __('دسته‌بندی خدمات', 'services-post-type'),
            'singular_name'              => __('دسته‌بندی خدمت', 'services-post-type'),
            'menu_name'                  => __('دسته‌بندی خدمات', 'services-post-type'),
            'all_items'                  => __('همه دسته‌بندی‌ها', 'services-post-type'),
            'parent_item'                => __('دسته‌بندی والد', 'services-post-type'),
            'parent_item_colon'          => __('دسته‌بندی والد:', 'services-post-type'),
            'new_item_name'              => __('نام دسته‌بندی جدید', 'services-post-type'),
            'add_new_item'               => __('افزودن دسته‌بندی جدید', 'services-post-type'),
            'edit_item'                  => __('ویرایش دسته‌بندی', 'services-post-type'),
            'update_item'                => __('بروزرسانی دسته‌بندی', 'services-post-type'),
            'view_item'                  => __('مشاهده دسته‌بندی', 'services-post-type'),
            'separate_items_with_commas' => __('دسته‌بندی‌ها را با کاما جدا کنید', 'services-post-type'),
            'add_or_remove_items'        => __('افزودن یا حذف دسته‌بندی‌ها', 'services-post-type'),
            'choose_from_most_used'      => __('انتخاب از پرکاربردترین‌ها', 'services-post-type'),
            'popular_items'              => __('دسته‌بندی‌های محبوب', 'services-post-type'),
            'search_items'               => __('جستجو دسته‌بندی‌ها', 'services-post-type'),
            'not_found'                  => __('دسته‌بندی یافت نشد', 'services-post-type'),
            'no_terms'                   => __('بدون دسته‌بندی', 'services-post-type'),
            'items_list'                 => __('لیست دسته‌بندی‌ها', 'services-post-type'),
            'items_list_navigation'      => __('ناوبری لیست دسته‌بندی‌ها', 'services-post-type'),
        );

        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => false,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => false,
            'show_tagcloud'              => false,
            'show_in_rest'               => true,
        );

        register_taxonomy('service-category', array('services'), $args);
    }
}