<?php
/**
 * Services Helper Functions
 * توابع کمکی خدمات
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * تابع کمکی برای شمارش خدمات مشتری
 */
function get_customer_services_count($customer_id) {
    $services_query = new WP_Query(array(
        'post_type' => 'services',
        'posts_per_page' => -1,
        'meta_query' => array(
            array(
                'key' => 'customer_relation',
                'value' => $customer_id,
                'compare' => '='
            )
        ),
        'post_status' => 'publish',
        'fields' => 'ids'
    ));
    
    return $services_query->found_posts;
}

/**
 * دریافت خدمات مشتری
 */
function get_customer_services($customer_id = null, $limit = -1) {
    if (!$customer_id) {
        $customer_id = get_the_ID();
    }
    
    $services_query = new WP_Query(array(
        'post_type' => 'services',
        'posts_per_page' => $limit,
        'meta_query' => array(
            array(
                'key' => 'customer_relation',
                'value' => $customer_id,
                'compare' => '='
            )
        ),
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC'
    ));
    
    return $services_query->posts;
}

/**
 * دریافت مشتری مرتبط با خدمت
 */
function get_service_customer($service_id = null) {
    if (!$service_id) {
        $service_id = get_the_ID();
    }
    
    $customer_id = get_post_meta($service_id, 'customer_relation', true);
    
    if ($customer_id) {
        return get_post($customer_id);
    }
    
    return null;
}

/**
 * دریافت وضعیت خدمت
 */
function get_service_status($service_id = null) {
    if (!$service_id) {
        $service_id = get_the_ID();
    }
    
    $status = get_post_meta($service_id, 'service_status', true);
    
    $status_labels = array(
        'planning' => __('در حال برنامه‌ریزی', 'services-post-type'),
        'in_progress' => __('در حال انجام', 'services-post-type'),
        'completed' => __('تکمیل شده', 'services-post-type'),
        'on_hold' => __('متوقف شده', 'services-post-type'),
        'cancelled' => __('لغو شده', 'services-post-type')
    );
    
    return isset($status_labels[$status]) ? $status_labels[$status] : __('تعریف نشده', 'services-post-type');
}

/**
 * دریافت قیمت خدمت
 */
function get_service_price($service_id = null, $formatted = true) {
    if (!$service_id) {
        $service_id = get_the_ID();
    }
    
    $price = get_post_meta($service_id, 'service_price', true);
    
    if ($formatted && $price) {
        return number_format($price) . ' ' . __('تومان', 'services-post-type');
    }
    
    return $price;
}

/**
 * بررسی اینکه آیا خدمت از نوع طراحی وب است
 */
function is_web_design_service($service_id = null) {
    if (!$service_id) {
        $service_id = get_the_ID();
    }
    
    $categories = get_the_terms($service_id, 'service-category');
    
    if ($categories && !is_wp_error($categories)) {
        foreach ($categories as $category) {
            if ($category->name === 'طراحی وب') {
                return true;
            }
        }
    }
    
    return false;
}