<?php
/**
 * Plugin Name: Services Post Type
 * Plugin URI: https://yourwebsite.com
 * Description: سیستم کامل مدیریت خدمات ارائه شده با قابلیت ارتباط با مشتریان
 * Version: 1.0.0
 * Author: Your Name
 * Author URI: https://yourwebsite.com
 * Text Domain: services-post-type
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.4
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}

// تعریف ثابت‌های پلاگین
define('SERVICES_PLUGIN_VERSION', '1.0.0');
define('SERVICES_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SERVICES_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('SERVICES_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * کلاس اصلی پلاگین
 */
class ServicesPostTypePlugin {
    
    /**
     * نمونه واحد کلاس
     */
    private static $instance = null;
    
    /**
     * دریافت نمونه واحد
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * سازنده کلاس
     */
    private function __construct() {
        $this->init();
    }
    
    /**
     * راه‌اندازی پلاگین
     */
    private function init() {
        // بارگذاری فایل‌ها
        $this->load_files();
        
        // اضافه کردن هوک‌ها
        add_action('init', array($this, 'init_plugin'));
        add_action('plugins_loaded', array($this, 'load_textdomain'));
        
        // هوک‌های فعال‌سازی و غیرفعال‌سازی
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    /**
     * بارگذاری فایل‌ها
     */
    private function load_files() {
        require_once SERVICES_PLUGIN_PATH . 'includes/class-post-type.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/class-taxonomy.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/class-meta-boxes.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/class-admin-columns.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/class-shortcodes.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/class-image-settings.php';
        require_once SERVICES_PLUGIN_PATH . 'includes/helper-functions.php';
        require_once SERVICES_PLUGIN_PATH . 'admin/class-admin.php';
    }
    
    /**
     * راه‌اندازی اجزای پلاگین
     */
    public function init_plugin() {
        // راه‌اندازی کلاس‌ها
        Services_Post_Type::get_instance();
        Services_Taxonomy::get_instance();
        Services_Meta_Boxes::get_instance();
        Services_Admin_Columns::get_instance();
        Services_Shortcodes::get_instance();
        Services_Image_Settings::get_instance();
        
        if (is_admin()) {
            Services_Admin::get_instance();
        }
    }
    
    /**
     * بارگذاری فایل‌های ترجمه
     */
    public function load_textdomain() {
        load_plugin_textdomain('services-post-type', false, dirname(SERVICES_PLUGIN_BASENAME) . '/languages');
    }
    
    /**
     * فعال‌سازی پلاگین
     */
    public function activate() {
        // ایجاد نوع پست و تکسونومی
        Services_Post_Type::get_instance()->register_post_type();
        Services_Taxonomy::get_instance()->register_taxonomy();
        
        // به‌روزرسانی قوانین URL
        flush_rewrite_rules();
        
        // اضافه کردن دسته‌بندی‌های پیش‌فرض
        $this->add_default_categories();
        
        // ذخیره نسخه پلاگین
        update_option('services_plugin_version', SERVICES_PLUGIN_VERSION);
    }
    
    /**
     * غیرفعال‌سازی پلاگین
     */
    public function deactivate() {
        // به‌روزرسانی قوانین URL
        flush_rewrite_rules();
    }
    
    /**
     * اضافه کردن دسته‌بندی‌های پیش‌فرض
     */
    private function add_default_categories() {
        $default_categories = array(
            'طراحی وب',
            'توسعه نرم‌افزار',
            'مشاوره فنی',
            'پشتیبانی',
            'سئو و بهینه‌سازی',
            'طراحی گرافیک'
        );
        
        foreach ($default_categories as $category) {
            if (!term_exists($category, 'service-category')) {
                wp_insert_term($category, 'service-category');
            }
        }
    }
}

// راه‌اندازی پلاگین
ServicesPostTypePlugin::get_instance();